/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.scanner.Token;

public class ThrowExpression
extends Expression {
    private Token keyword;
    private Expression expression;

    public ThrowExpression(Token token, Expression expression) {
        this.keyword = token;
        this.expression = this.becomeParentOf(expression);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitThrowExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.keyword;
    }

    @Override
    public Token getEndToken() {
        if (this.expression != null) {
            return this.expression.getEndToken();
        }
        return this.keyword;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Token getKeyword() {
        return this.keyword;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.expression, astVisitor);
    }
}

