/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.SwitchMember;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class SwitchStatement
extends Statement {
    private Token keyword;
    private Token leftParenthesis;
    private Expression expression;
    private Token rightParenthesis;
    private Token leftBracket;
    private NodeList<SwitchMember> members = new NodeList(this);
    private Token rightBracket;

    public SwitchStatement(Token token, Token token2, Expression expression, Token token3, Token token4, List<SwitchMember> list, Token token5) {
        this.keyword = token;
        this.leftParenthesis = token2;
        this.expression = this.becomeParentOf(expression);
        this.rightParenthesis = token3;
        this.leftBracket = token4;
        this.members.addAll(list);
        this.rightBracket = token5;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitSwitchStatement(this);
    }

    @Override
    public Token getBeginToken() {
        return this.keyword;
    }

    @Override
    public Token getEndToken() {
        return this.rightBracket;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public Token getLeftBracket() {
        return this.leftBracket;
    }

    public Token getLeftParenthesis() {
        return this.leftParenthesis;
    }

    public NodeList<SwitchMember> getMembers() {
        return this.members;
    }

    public Token getRightBracket() {
        return this.rightBracket;
    }

    public Token getRightParenthesis() {
        return this.rightParenthesis;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setLeftBracket(Token token) {
        this.leftBracket = token;
    }

    public void setLeftParenthesis(Token token) {
        this.leftParenthesis = token;
    }

    public void setRightBracket(Token token) {
        this.rightBracket = token;
    }

    public void setRightParenthesis(Token token) {
        this.rightParenthesis = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.expression, astVisitor);
        this.members.accept(astVisitor);
    }
}

