/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.utilities.general.StringUtilities;

public class SimpleStringLiteral
extends StringLiteral {
    private Token literal;
    private String value;
    private Element toolkitElement;

    public SimpleStringLiteral(Token token, String string) {
        this.literal = token;
        this.value = StringUtilities.intern(string);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitSimpleStringLiteral(this);
    }

    @Override
    public Token getBeginToken() {
        return this.literal;
    }

    @Override
    public Token getEndToken() {
        return this.literal;
    }

    public Token getLiteral() {
        return this.literal;
    }

    public Element getToolkitElement() {
        return this.toolkitElement;
    }

    public String getValue() {
        return this.value;
    }

    public int getValueOffset() {
        int n = 0;
        if (this.isRaw()) {
            ++n;
        }
        n = this.isMultiline() ? (n += 3) : ++n;
        return this.getOffset() + n;
    }

    public boolean isMultiline() {
        String string = this.literal.getLexeme();
        if (string.length() < 6) {
            return false;
        }
        return StringUtilities.endsWith3(string, 34, 34, 34) || StringUtilities.endsWith3(string, 39, 39, 39);
    }

    public boolean isRaw() {
        return this.literal.getLexeme().charAt(0) == 'r';
    }

    @Override
    public boolean isSynthetic() {
        return this.literal.isSynthetic();
    }

    public void setLiteral(Token token) {
        this.literal = token;
    }

    public void setToolkitElement(Element element) {
        this.toolkitElement = element;
    }

    public void setValue(String string) {
        this.value = StringUtilities.intern(this.value);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
    }

    @Override
    protected void appendStringValue(StringBuilder stringBuilder) {
        stringBuilder.append(this.getValue());
    }
}

