/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.internal.element.AuxiliaryElements;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;

public class SimpleIdentifier
extends Identifier {
    private Token token;
    private Element staticElement;
    private Element propagatedElement;
    private AuxiliaryElements auxiliaryElements = null;

    public SimpleIdentifier(Token token) {
        this.token = token;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitSimpleIdentifier(this);
    }

    public AuxiliaryElements getAuxiliaryElements() {
        return this.auxiliaryElements;
    }

    @Override
    public Token getBeginToken() {
        return this.token;
    }

    @Override
    public Element getBestElement() {
        if (this.propagatedElement == null) {
            return this.staticElement;
        }
        return this.propagatedElement;
    }

    @Override
    public Token getEndToken() {
        return this.token;
    }

    @Override
    public String getName() {
        return this.token.getLexeme();
    }

    @Override
    public int getPrecedence() {
        return 16;
    }

    @Override
    public Element getPropagatedElement() {
        return this.propagatedElement;
    }

    @Override
    public Element getStaticElement() {
        return this.staticElement;
    }

    public Token getToken() {
        return this.token;
    }

    public boolean inDeclarationContext() {
        AstNode astNode = this.getParent();
        if (astNode instanceof CatchClause) {
            CatchClause catchClause = (CatchClause)astNode;
            return this == catchClause.getExceptionParameter() || this == catchClause.getStackTraceParameter();
        }
        if (astNode instanceof ClassDeclaration) {
            return this == ((ClassDeclaration)astNode).getName();
        }
        if (astNode instanceof ClassTypeAlias) {
            return this == ((ClassTypeAlias)astNode).getName();
        }
        if (astNode instanceof ConstructorDeclaration) {
            return this == ((ConstructorDeclaration)astNode).getName();
        }
        if (astNode instanceof DeclaredIdentifier) {
            return this == ((DeclaredIdentifier)astNode).getIdentifier();
        }
        if (astNode instanceof FunctionDeclaration) {
            return this == ((FunctionDeclaration)astNode).getName();
        }
        if (astNode instanceof FunctionTypeAlias) {
            return this == ((FunctionTypeAlias)astNode).getName();
        }
        if (astNode instanceof Label) {
            return this == ((Label)astNode).getLabel() && astNode.getParent() instanceof LabeledStatement;
        }
        if (astNode instanceof MethodDeclaration) {
            return this == ((MethodDeclaration)astNode).getName();
        }
        if (astNode instanceof FunctionTypedFormalParameter || astNode instanceof SimpleFormalParameter) {
            return this == ((NormalFormalParameter)astNode).getIdentifier();
        }
        if (astNode instanceof TypeParameter) {
            return this == ((TypeParameter)astNode).getName();
        }
        if (astNode instanceof VariableDeclaration) {
            return this == ((VariableDeclaration)astNode).getName();
        }
        return false;
    }

    public boolean inGetterContext() {
        Expression expression;
        AstNode astNode = this.getParent();
        Expression expression2 = this;
        if (astNode instanceof PrefixedIdentifier) {
            expression = (PrefixedIdentifier)astNode;
            if (((PrefixedIdentifier)expression).getPrefix() == this) {
                return true;
            }
            astNode = expression.getParent();
            expression2 = expression;
        } else if (astNode instanceof PropertyAccess) {
            expression = (PropertyAccess)astNode;
            if (((PropertyAccess)expression).getTarget() == this) {
                return true;
            }
            astNode = expression.getParent();
            expression2 = expression;
        }
        if (astNode instanceof Label) {
            return false;
        }
        return !(astNode instanceof AssignmentExpression) || ((AssignmentExpression)(expression = (AssignmentExpression)astNode)).getLeftHandSide() != expression2 || ((AssignmentExpression)expression).getOperator().getType() != TokenType.EQ;
    }

    public boolean inSetterContext() {
        AstNode astNode = this.getParent();
        Expression expression = this;
        if (astNode instanceof PrefixedIdentifier) {
            PrefixedIdentifier prefixedIdentifier = (PrefixedIdentifier)astNode;
            if (prefixedIdentifier.getPrefix() == this) {
                return false;
            }
            astNode = prefixedIdentifier.getParent();
            expression = prefixedIdentifier;
        } else if (astNode instanceof PropertyAccess) {
            PropertyAccess propertyAccess = (PropertyAccess)astNode;
            if (propertyAccess.getTarget() == this) {
                return false;
            }
            astNode = propertyAccess.getParent();
            expression = propertyAccess;
        }
        if (astNode instanceof PrefixExpression) {
            return ((PrefixExpression)astNode).getOperator().getType().isIncrementOperator();
        }
        if (astNode instanceof PostfixExpression) {
            return true;
        }
        if (astNode instanceof AssignmentExpression) {
            return ((AssignmentExpression)astNode).getLeftHandSide() == expression;
        }
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return this.token.isSynthetic();
    }

    public void setAuxiliaryElements(AuxiliaryElements auxiliaryElements) {
        this.auxiliaryElements = auxiliaryElements;
    }

    public void setPropagatedElement(Element element) {
        this.propagatedElement = this.validateElement(element);
    }

    public void setStaticElement(Element element) {
        this.staticElement = this.validateElement(element);
    }

    public void setToken(Token token) {
        this.token = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
    }

    private Element returnOrReportElement(AstNode astNode, boolean bl, Element element) {
        if (!bl) {
            AnalysisEngine.getInstance().getLogger().logInformation("Internal error: attempting to set the name of a " + astNode.getClass().getName() + " to a " + element.getClass().getName(), new Exception());
            return null;
        }
        return element;
    }

    private Element validateElement(Element element) {
        if (element == null) {
            return null;
        }
        AstNode astNode = this.getParent();
        if (astNode instanceof ClassDeclaration && ((ClassDeclaration)astNode).getName() == this) {
            return this.returnOrReportElement(astNode, element instanceof ClassElement, element);
        }
        if (astNode instanceof ClassTypeAlias && ((ClassTypeAlias)astNode).getName() == this) {
            return this.returnOrReportElement(astNode, element instanceof ClassElement, element);
        }
        if (astNode instanceof DeclaredIdentifier && ((DeclaredIdentifier)astNode).getIdentifier() == this) {
            return this.returnOrReportElement(astNode, element instanceof LocalVariableElement, element);
        }
        if (astNode instanceof FormalParameter && ((FormalParameter)astNode).getIdentifier() == this) {
            return this.returnOrReportElement(astNode, element instanceof ParameterElement, element);
        }
        if (astNode instanceof FunctionDeclaration && ((FunctionDeclaration)astNode).getName() == this) {
            return this.returnOrReportElement(astNode, element instanceof ExecutableElement, element);
        }
        if (astNode instanceof FunctionTypeAlias && ((FunctionTypeAlias)astNode).getName() == this) {
            return this.returnOrReportElement(astNode, element instanceof FunctionTypeAliasElement, element);
        }
        if (astNode instanceof MethodDeclaration && ((MethodDeclaration)astNode).getName() == this) {
            return this.returnOrReportElement(astNode, element instanceof ExecutableElement, element);
        }
        if (astNode instanceof TypeParameter && ((TypeParameter)astNode).getName() == this) {
            return this.returnOrReportElement(astNode, element instanceof TypeParameterElement, element);
        }
        if (astNode instanceof VariableDeclaration && ((VariableDeclaration)astNode).getName() == this) {
            return this.returnOrReportElement(astNode, element instanceof VariableElement, element);
        }
        return element;
    }
}

