/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class SimpleFormalParameter
extends NormalFormalParameter {
    private Token keyword;
    private TypeName type;

    public SimpleFormalParameter(Comment comment, List<Annotation> list, Token token, TypeName typeName, SimpleIdentifier simpleIdentifier) {
        super(comment, list, simpleIdentifier);
        this.keyword = token;
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitSimpleFormalParameter(this);
    }

    @Override
    public Token getBeginToken() {
        if (this.keyword != null) {
            return this.keyword;
        }
        if (this.type != null) {
            return this.type.getBeginToken();
        }
        return this.getIdentifier().getBeginToken();
    }

    @Override
    public Token getEndToken() {
        return this.getIdentifier().getEndToken();
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public TypeName getType() {
        return this.type;
    }

    @Override
    public boolean isConst() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.CONST;
    }

    @Override
    public boolean isFinal() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.FINAL;
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setType(TypeName typeName) {
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.type, astVisitor);
        this.safelyVisitChild(this.getIdentifier(), astVisitor);
    }
}

