/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.ConstructorInitializer;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.scanner.Token;

public class RedirectingConstructorInvocation
extends ConstructorInitializer {
    private Token keyword;
    private Token period;
    private SimpleIdentifier constructorName;
    private ArgumentList argumentList;
    private ConstructorElement staticElement;

    public RedirectingConstructorInvocation(Token token, Token token2, SimpleIdentifier simpleIdentifier, ArgumentList argumentList) {
        this.keyword = token;
        this.period = token2;
        this.constructorName = this.becomeParentOf(simpleIdentifier);
        this.argumentList = this.becomeParentOf(argumentList);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitRedirectingConstructorInvocation(this);
    }

    public ArgumentList getArgumentList() {
        return this.argumentList;
    }

    @Override
    public Token getBeginToken() {
        return this.keyword;
    }

    public SimpleIdentifier getConstructorName() {
        return this.constructorName;
    }

    @Override
    public Token getEndToken() {
        return this.argumentList.getEndToken();
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public Token getPeriod() {
        return this.period;
    }

    public ConstructorElement getStaticElement() {
        return this.staticElement;
    }

    public void setArgumentList(ArgumentList argumentList) {
        this.argumentList = this.becomeParentOf(argumentList);
    }

    public void setConstructorName(SimpleIdentifier simpleIdentifier) {
        this.constructorName = this.becomeParentOf(simpleIdentifier);
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    public void setStaticElement(ConstructorElement constructorElement) {
        this.staticElement = constructorElement;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.constructorName, astVisitor);
        this.safelyVisitChild(this.argumentList, astVisitor);
    }
}

