/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;

public class PropertyAccess
extends Expression {
    private Expression target;
    private Token operator;
    private SimpleIdentifier propertyName;

    public PropertyAccess(Expression expression, Token token, SimpleIdentifier simpleIdentifier) {
        this.target = this.becomeParentOf(expression);
        this.operator = token;
        this.propertyName = this.becomeParentOf(simpleIdentifier);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitPropertyAccess(this);
    }

    @Override
    public Token getBeginToken() {
        if (this.target != null) {
            return this.target.getBeginToken();
        }
        return this.operator;
    }

    @Override
    public Token getEndToken() {
        return this.propertyName.getEndToken();
    }

    public Token getOperator() {
        return this.operator;
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    public SimpleIdentifier getPropertyName() {
        return this.propertyName;
    }

    public Expression getRealTarget() {
        if (this.isCascaded()) {
            AstNode astNode = this.getParent();
            while (!(astNode instanceof CascadeExpression)) {
                if (astNode == null) {
                    return this.target;
                }
                astNode = astNode.getParent();
            }
            return ((CascadeExpression)astNode).getTarget();
        }
        return this.target;
    }

    public Expression getTarget() {
        return this.target;
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    public boolean isCascaded() {
        return this.operator != null && this.operator.getType() == TokenType.PERIOD_PERIOD;
    }

    public void setOperator(Token token) {
        this.operator = token;
    }

    public void setPropertyName(SimpleIdentifier simpleIdentifier) {
        this.propertyName = this.becomeParentOf(simpleIdentifier);
    }

    public void setTarget(Expression expression) {
        this.target = this.becomeParentOf(expression);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.target, astVisitor);
        this.safelyVisitChild(this.propertyName, astVisitor);
    }
}

