/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.scanner.Token;

public class PrefixedIdentifier
extends Identifier {
    private SimpleIdentifier prefix;
    private Token period;
    private SimpleIdentifier identifier;

    public PrefixedIdentifier(SimpleIdentifier simpleIdentifier, Token token, SimpleIdentifier simpleIdentifier2) {
        this.prefix = this.becomeParentOf(simpleIdentifier);
        this.period = token;
        this.identifier = this.becomeParentOf(simpleIdentifier2);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitPrefixedIdentifier(this);
    }

    @Override
    public Token getBeginToken() {
        return this.prefix.getBeginToken();
    }

    @Override
    public Element getBestElement() {
        if (this.identifier == null) {
            return null;
        }
        return this.identifier.getBestElement();
    }

    @Override
    public Token getEndToken() {
        return this.identifier.getEndToken();
    }

    public SimpleIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        return this.prefix.getName() + "." + this.identifier.getName();
    }

    public Token getPeriod() {
        return this.period;
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    public SimpleIdentifier getPrefix() {
        return this.prefix;
    }

    @Override
    public Element getPropagatedElement() {
        if (this.identifier == null) {
            return null;
        }
        return this.identifier.getPropagatedElement();
    }

    @Override
    public Element getStaticElement() {
        if (this.identifier == null) {
            return null;
        }
        return this.identifier.getStaticElement();
    }

    public void setIdentifier(SimpleIdentifier simpleIdentifier) {
        this.identifier = this.becomeParentOf(simpleIdentifier);
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    public void setPrefix(SimpleIdentifier simpleIdentifier) {
        this.prefix = this.becomeParentOf(simpleIdentifier);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.prefix, astVisitor);
        this.safelyVisitChild(this.identifier, astVisitor);
    }
}

