/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.scanner.Token;

public class PrefixExpression
extends Expression {
    private Token operator;
    private Expression operand;
    private MethodElement staticElement;
    private MethodElement propagatedElement;

    public PrefixExpression(Token token, Expression expression) {
        this.operator = token;
        this.operand = this.becomeParentOf(expression);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitPrefixExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.operator;
    }

    public MethodElement getBestElement() {
        MethodElement methodElement = this.getPropagatedElement();
        if (methodElement == null) {
            methodElement = this.getStaticElement();
        }
        return methodElement;
    }

    @Override
    public Token getEndToken() {
        return this.operand.getEndToken();
    }

    public Expression getOperand() {
        return this.operand;
    }

    public Token getOperator() {
        return this.operator;
    }

    @Override
    public int getPrecedence() {
        return 14;
    }

    public MethodElement getPropagatedElement() {
        return this.propagatedElement;
    }

    public MethodElement getStaticElement() {
        return this.staticElement;
    }

    public void setOperand(Expression expression) {
        this.operand = this.becomeParentOf(expression);
    }

    public void setOperator(Token token) {
        this.operator = token;
    }

    public void setPropagatedElement(MethodElement methodElement) {
        this.propagatedElement = methodElement;
    }

    public void setStaticElement(MethodElement methodElement) {
        this.staticElement = methodElement;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.operand, astVisitor);
    }

    protected ParameterElement getPropagatedParameterElementForOperand() {
        if (this.propagatedElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = this.propagatedElement.getParameters();
        if (parameterElementArray.length < 1) {
            return null;
        }
        return parameterElementArray[0];
    }

    protected ParameterElement getStaticParameterElementForOperand() {
        if (this.staticElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = this.staticElement.getParameters();
        if (parameterElementArray.length < 1) {
            return null;
        }
        return parameterElementArray[0];
    }
}

