/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.scanner.Token;

public class ParenthesizedExpression
extends Expression {
    private Token leftParenthesis;
    private Expression expression;
    private Token rightParenthesis;

    public ParenthesizedExpression(Token token, Expression expression, Token token2) {
        this.leftParenthesis = token;
        this.expression = this.becomeParentOf(expression);
        this.rightParenthesis = token2;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitParenthesizedExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.leftParenthesis;
    }

    @Override
    public Token getEndToken() {
        return this.rightParenthesis;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Token getLeftParenthesis() {
        return this.leftParenthesis;
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    public Token getRightParenthesis() {
        return this.rightParenthesis;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setLeftParenthesis(Token token) {
        this.leftParenthesis = token;
    }

    public void setRightParenthesis(Token token) {
        this.rightParenthesis = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.expression, astVisitor);
    }
}

