/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.utilities.dart.ParameterKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class NormalFormalParameter
extends FormalParameter {
    private Comment comment;
    private NodeList<Annotation> metadata = new NodeList(this);
    private SimpleIdentifier identifier;

    public NormalFormalParameter(Comment comment, List<Annotation> list, SimpleIdentifier simpleIdentifier) {
        this.comment = this.becomeParentOf(comment);
        this.metadata.addAll(list);
        this.identifier = this.becomeParentOf(simpleIdentifier);
    }

    public Comment getDocumentationComment() {
        return this.comment;
    }

    @Override
    public SimpleIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public ParameterKind getKind() {
        AstNode astNode = this.getParent();
        if (astNode instanceof DefaultFormalParameter) {
            return ((DefaultFormalParameter)astNode).getKind();
        }
        return ParameterKind.REQUIRED;
    }

    public NodeList<Annotation> getMetadata() {
        return this.metadata;
    }

    public void setDocumentationComment(Comment comment) {
        this.comment = this.becomeParentOf(comment);
    }

    public void setIdentifier(SimpleIdentifier simpleIdentifier) {
        this.identifier = this.becomeParentOf(simpleIdentifier);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        if (this.commentIsBeforeAnnotations()) {
            this.safelyVisitChild(this.comment, astVisitor);
            this.metadata.accept(astVisitor);
        } else {
            for (AstNode astNode : this.getSortedCommentAndAnnotations()) {
                astNode.accept(astVisitor);
            }
        }
    }

    private boolean commentIsBeforeAnnotations() {
        if (this.comment == null || this.metadata.isEmpty()) {
            return true;
        }
        Annotation annotation = (Annotation)this.metadata.get(0);
        return this.comment.getOffset() < annotation.getOffset();
    }

    private AstNode[] getSortedCommentAndAnnotations() {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        arrayList.add(this.comment);
        arrayList.addAll(this.metadata);
        AstNode[] astNodeArray = arrayList.toArray(new AstNode[arrayList.size()]);
        Arrays.sort(astNodeArray, AstNode.LEXICAL_ORDER);
        return astNodeArray;
    }
}

