/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.utilities.translation.DartOmit;
import java.util.AbstractList;
import java.util.Collection;

@DartOmit
public class NodeList<E extends AstNode>
extends AbstractList<E> {
    private final AstNode owner;
    private AstNode[] elements = AstNode.EMPTY_ARRAY;

    public static <E extends AstNode> NodeList<E> create(AstNode astNode) {
        return new NodeList<E>(astNode);
    }

    public NodeList(AstNode astNode) {
        this.owner = astNode;
    }

    public void accept(AstVisitor<?> astVisitor) {
        for (AstNode astNode : this.elements) {
            astNode.accept(astVisitor);
        }
    }

    @Override
    public void add(int n, E e) {
        int n2 = this.elements.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.elements.length);
        }
        this.owner.becomeParentOf(e);
        if (n2 == 0) {
            this.elements = new AstNode[]{e};
        } else {
            AstNode[] astNodeArray = new AstNode[n2 + 1];
            System.arraycopy(this.elements, 0, astNodeArray, 0, n);
            astNodeArray[n] = e;
            System.arraycopy(this.elements, n, astNodeArray, n + 1, n2 - n);
            this.elements = astNodeArray;
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection != null && !collection.isEmpty()) {
            int n = this.elements.length;
            int n2 = collection.size();
            AstNode[] astNodeArray = new AstNode[n + n2];
            System.arraycopy(this.elements, 0, astNodeArray, 0, n);
            int n3 = n;
            for (AstNode astNode : collection) {
                this.owner.becomeParentOf(astNode);
                astNodeArray[n3++] = astNode;
            }
            this.elements = astNodeArray;
            return true;
        }
        return false;
    }

    @Override
    public E get(int n) {
        if (n < 0 || n >= this.elements.length) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.elements.length);
        }
        return (E)this.elements[n];
    }

    public Token getBeginToken() {
        if (this.elements.length == 0) {
            return null;
        }
        return this.elements[0].getBeginToken();
    }

    public Token getEndToken() {
        if (this.elements.length == 0) {
            return null;
        }
        return this.elements[this.elements.length - 1].getEndToken();
    }

    public AstNode getOwner() {
        return this.owner;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] != object) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E remove(int n) {
        if (n < 0 || n >= this.elements.length) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.elements.length);
        }
        AstNode astNode = this.elements[n];
        int n2 = this.elements.length;
        if (n2 == 1) {
            this.elements = AstNode.EMPTY_ARRAY;
            return (E)astNode;
        }
        AstNode[] astNodeArray = new AstNode[n2 - 1];
        System.arraycopy(this.elements, 0, astNodeArray, 0, n);
        System.arraycopy(this.elements, n + 1, astNodeArray, n, n2 - n - 1);
        this.elements = astNodeArray;
        return (E)astNode;
    }

    @Override
    public E set(int n, E e) {
        if (n < 0 || n >= this.elements.length) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.elements.length);
        }
        AstNode astNode = this.elements[n];
        this.owner.becomeParentOf(e);
        this.elements[n] = e;
        return (E)astNode;
    }

    @Override
    public int size() {
        return this.elements.length;
    }
}

