/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.scanner.Token;

public class NamedExpression
extends Expression {
    private Label name;
    private Expression expression;

    public NamedExpression(Label label, Expression expression) {
        this.name = this.becomeParentOf(label);
        this.expression = this.becomeParentOf(expression);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitNamedExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.name.getBeginToken();
    }

    public ParameterElement getElement() {
        Element element = this.name.getLabel().getStaticElement();
        if (element instanceof ParameterElement) {
            return (ParameterElement)element;
        }
        return null;
    }

    @Override
    public Token getEndToken() {
        return this.expression.getEndToken();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Label getName() {
        return this.name;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setName(Label label) {
        this.name = this.becomeParentOf(label);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.expression, astVisitor);
    }
}

