/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;

public class MethodInvocation
extends Expression {
    private Expression target;
    private Token period;
    private SimpleIdentifier methodName;
    private ArgumentList argumentList;

    public MethodInvocation(Expression expression, Token token, SimpleIdentifier simpleIdentifier, ArgumentList argumentList) {
        this.target = this.becomeParentOf(expression);
        this.period = token;
        this.methodName = this.becomeParentOf(simpleIdentifier);
        this.argumentList = this.becomeParentOf(argumentList);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitMethodInvocation(this);
    }

    public ArgumentList getArgumentList() {
        return this.argumentList;
    }

    @Override
    public Token getBeginToken() {
        if (this.target != null) {
            return this.target.getBeginToken();
        }
        if (this.period != null) {
            return this.period;
        }
        return this.methodName.getBeginToken();
    }

    @Override
    public Token getEndToken() {
        return this.argumentList.getEndToken();
    }

    public SimpleIdentifier getMethodName() {
        return this.methodName;
    }

    public Token getPeriod() {
        return this.period;
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    public Expression getRealTarget() {
        if (this.isCascaded()) {
            AstNode astNode = this.getParent();
            while (!(astNode instanceof CascadeExpression)) {
                if (astNode == null) {
                    return this.target;
                }
                astNode = astNode.getParent();
            }
            return ((CascadeExpression)astNode).getTarget();
        }
        return this.target;
    }

    public Expression getTarget() {
        return this.target;
    }

    public boolean isCascaded() {
        return this.period != null && this.period.getType() == TokenType.PERIOD_PERIOD;
    }

    public void setArgumentList(ArgumentList argumentList) {
        this.argumentList = this.becomeParentOf(argumentList);
    }

    public void setMethodName(SimpleIdentifier simpleIdentifier) {
        this.methodName = this.becomeParentOf(simpleIdentifier);
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    public void setTarget(Expression expression) {
        this.target = this.becomeParentOf(expression);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.target, astVisitor);
        this.safelyVisitChild(this.methodName, astVisitor);
        this.safelyVisitChild(this.argumentList, astVisitor);
    }
}

