/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.EmptyFunctionBody;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class MethodDeclaration
extends ClassMember {
    private Token externalKeyword;
    private Token modifierKeyword;
    private TypeName returnType;
    private Token propertyKeyword;
    private Token operatorKeyword;
    private SimpleIdentifier name;
    private FormalParameterList parameters;
    private FunctionBody body;

    public MethodDeclaration(Comment comment, List<Annotation> list, Token token, Token token2, TypeName typeName, Token token3, Token token4, SimpleIdentifier simpleIdentifier, FormalParameterList formalParameterList, FunctionBody functionBody) {
        super(comment, list);
        this.externalKeyword = token;
        this.modifierKeyword = token2;
        this.returnType = this.becomeParentOf(typeName);
        this.propertyKeyword = token3;
        this.operatorKeyword = token4;
        this.name = this.becomeParentOf(simpleIdentifier);
        this.parameters = this.becomeParentOf(formalParameterList);
        this.body = this.becomeParentOf(functionBody);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitMethodDeclaration(this);
    }

    public FunctionBody getBody() {
        return this.body;
    }

    @Override
    public ExecutableElement getElement() {
        return this.name != null ? (ExecutableElement)this.name.getStaticElement() : null;
    }

    @Override
    public Token getEndToken() {
        return this.body.getEndToken();
    }

    public Token getExternalKeyword() {
        return this.externalKeyword;
    }

    public Token getModifierKeyword() {
        return this.modifierKeyword;
    }

    public SimpleIdentifier getName() {
        return this.name;
    }

    public Token getOperatorKeyword() {
        return this.operatorKeyword;
    }

    public FormalParameterList getParameters() {
        return this.parameters;
    }

    public Token getPropertyKeyword() {
        return this.propertyKeyword;
    }

    public TypeName getReturnType() {
        return this.returnType;
    }

    public boolean isAbstract() {
        return this.externalKeyword == null && this.body instanceof EmptyFunctionBody;
    }

    public boolean isGetter() {
        return this.propertyKeyword != null && ((KeywordToken)this.propertyKeyword).getKeyword() == Keyword.GET;
    }

    public boolean isOperator() {
        return this.operatorKeyword != null;
    }

    public boolean isSetter() {
        return this.propertyKeyword != null && ((KeywordToken)this.propertyKeyword).getKeyword() == Keyword.SET;
    }

    public boolean isStatic() {
        return this.modifierKeyword != null && ((KeywordToken)this.modifierKeyword).getKeyword() == Keyword.STATIC;
    }

    public void setBody(FunctionBody functionBody) {
        this.body = this.becomeParentOf(functionBody);
    }

    public void setExternalKeyword(Token token) {
        this.externalKeyword = token;
    }

    public void setModifierKeyword(Token token) {
        this.modifierKeyword = token;
    }

    public void setName(SimpleIdentifier simpleIdentifier) {
        this.name = this.becomeParentOf(simpleIdentifier);
    }

    public void setOperatorKeyword(Token token) {
        this.operatorKeyword = token;
    }

    public void setParameters(FormalParameterList formalParameterList) {
        this.parameters = this.becomeParentOf(formalParameterList);
    }

    public void setPropertyKeyword(Token token) {
        this.propertyKeyword = token;
    }

    public void setReturnType(TypeName typeName) {
        this.returnType = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.returnType, astVisitor);
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.parameters, astVisitor);
        this.safelyVisitChild(this.body, astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        if (this.modifierKeyword != null) {
            return this.modifierKeyword;
        }
        if (this.returnType != null) {
            return this.returnType.getBeginToken();
        }
        if (this.propertyKeyword != null) {
            return this.propertyKeyword;
        }
        if (this.operatorKeyword != null) {
            return this.operatorKeyword;
        }
        return this.name.getBeginToken();
    }
}

