/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypedLiteral;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class MapLiteral
extends TypedLiteral {
    private Token leftBracket;
    private NodeList<MapLiteralEntry> entries = new NodeList(this);
    private Token rightBracket;

    public MapLiteral(Token token, TypeArgumentList typeArgumentList, Token token2, List<MapLiteralEntry> list, Token token3) {
        super(token, typeArgumentList);
        this.leftBracket = token2;
        this.entries.addAll(list);
        this.rightBracket = token3;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitMapLiteral(this);
    }

    @Override
    public Token getBeginToken() {
        Token token = this.getConstKeyword();
        if (token != null) {
            return token;
        }
        TypeArgumentList typeArgumentList = this.getTypeArguments();
        if (typeArgumentList != null) {
            return typeArgumentList.getBeginToken();
        }
        return this.leftBracket;
    }

    @Override
    public Token getEndToken() {
        return this.rightBracket;
    }

    public NodeList<MapLiteralEntry> getEntries() {
        return this.entries;
    }

    public Token getLeftBracket() {
        return this.leftBracket;
    }

    public Token getRightBracket() {
        return this.rightBracket;
    }

    public void setLeftBracket(Token token) {
        this.leftBracket = token;
    }

    public void setRightBracket(Token token) {
        this.rightBracket = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.entries.accept(astVisitor);
    }
}

