/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypedLiteral;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class ListLiteral
extends TypedLiteral {
    private Token leftBracket;
    private NodeList<Expression> elements = new NodeList(this);
    private Token rightBracket;

    public ListLiteral(Token token, TypeArgumentList typeArgumentList, Token token2, List<Expression> list, Token token3) {
        super(token, typeArgumentList);
        this.leftBracket = token2;
        this.elements.addAll(list);
        this.rightBracket = token3;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitListLiteral(this);
    }

    @Override
    public Token getBeginToken() {
        Token token = this.getConstKeyword();
        if (token != null) {
            return token;
        }
        TypeArgumentList typeArgumentList = this.getTypeArguments();
        if (typeArgumentList != null) {
            return typeArgumentList.getBeginToken();
        }
        return this.leftBracket;
    }

    public NodeList<Expression> getElements() {
        return this.elements;
    }

    @Override
    public Token getEndToken() {
        return this.rightBracket;
    }

    public Token getLeftBracket() {
        return this.leftBracket;
    }

    public Token getRightBracket() {
        return this.rightBracket;
    }

    public void setLeftBracket(Token token) {
        this.leftBracket = token;
    }

    public void setRightBracket(Token token) {
        this.rightBracket = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.elements.accept(astVisitor);
    }
}

