/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class LibraryIdentifier
extends Identifier {
    private NodeList<SimpleIdentifier> components = new NodeList(this);

    public LibraryIdentifier(List<SimpleIdentifier> list) {
        this.components.addAll(list);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitLibraryIdentifier(this);
    }

    @Override
    public Token getBeginToken() {
        return this.components.getBeginToken();
    }

    @Override
    public Element getBestElement() {
        return this.getStaticElement();
    }

    public NodeList<SimpleIdentifier> getComponents() {
        return this.components;
    }

    @Override
    public Token getEndToken() {
        return this.components.getEndToken();
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (SimpleIdentifier simpleIdentifier : this.components) {
            if (bl) {
                stringBuilder.append(".");
            } else {
                bl = true;
            }
            stringBuilder.append(simpleIdentifier.getName());
        }
        return stringBuilder.toString();
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    @Override
    public Element getPropagatedElement() {
        return null;
    }

    @Override
    public Element getStaticElement() {
        return null;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.components.accept(astVisitor);
    }
}

