/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class LibraryDirective
extends Directive {
    private Token libraryToken;
    private LibraryIdentifier name;
    private Token semicolon;

    public LibraryDirective(Comment comment, List<Annotation> list, Token token, LibraryIdentifier libraryIdentifier, Token token2) {
        super(comment, list);
        this.libraryToken = token;
        this.name = this.becomeParentOf(libraryIdentifier);
        this.semicolon = token2;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitLibraryDirective(this);
    }

    @Override
    public Token getEndToken() {
        return this.semicolon;
    }

    @Override
    public Token getKeyword() {
        return this.libraryToken;
    }

    public Token getLibraryToken() {
        return this.libraryToken;
    }

    public LibraryIdentifier getName() {
        return this.name;
    }

    public Token getSemicolon() {
        return this.semicolon;
    }

    public void setLibraryToken(Token token) {
        this.libraryToken = token;
    }

    public void setName(LibraryIdentifier libraryIdentifier) {
        this.name = this.becomeParentOf(libraryIdentifier);
    }

    public void setSemicolon(Token token) {
        this.semicolon = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.name, astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        return this.libraryToken;
    }
}

