/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class LabeledStatement
extends Statement {
    private NodeList<Label> labels = new NodeList(this);
    private Statement statement;

    public LabeledStatement(List<Label> list, Statement statement) {
        this.labels.addAll(list);
        this.statement = this.becomeParentOf(statement);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitLabeledStatement(this);
    }

    @Override
    public Token getBeginToken() {
        if (!this.labels.isEmpty()) {
            return this.labels.getBeginToken();
        }
        return this.statement.getBeginToken();
    }

    @Override
    public Token getEndToken() {
        return this.statement.getEndToken();
    }

    public NodeList<Label> getLabels() {
        return this.labels;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = this.becomeParentOf(statement);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.labels.accept(astVisitor);
        this.safelyVisitChild(this.statement, astVisitor);
    }
}

