/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.scanner.Token;

public class IsExpression
extends Expression {
    private Expression expression;
    private Token isOperator;
    private Token notOperator;
    private TypeName type;

    public IsExpression(Expression expression, Token token, Token token2, TypeName typeName) {
        this.expression = this.becomeParentOf(expression);
        this.isOperator = token;
        this.notOperator = token2;
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitIsExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.expression.getBeginToken();
    }

    @Override
    public Token getEndToken() {
        return this.type.getEndToken();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Token getIsOperator() {
        return this.isOperator;
    }

    public Token getNotOperator() {
        return this.notOperator;
    }

    @Override
    public int getPrecedence() {
        return 7;
    }

    public TypeName getType() {
        return this.type;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setIsOperator(Token token) {
        this.isOperator = token;
    }

    public void setNotOperator(Token token) {
        this.notOperator = token;
    }

    public void setType(TypeName typeName) {
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.expression, astVisitor);
        this.safelyVisitChild(this.type, astVisitor);
    }
}

