/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.InterpolationElement;
import com.google.dart.engine.scanner.Token;

public class InterpolationExpression
extends InterpolationElement {
    private Token leftBracket;
    private Expression expression;
    private Token rightBracket;

    public InterpolationExpression(Token token, Expression expression, Token token2) {
        this.leftBracket = token;
        this.expression = this.becomeParentOf(expression);
        this.rightBracket = token2;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitInterpolationExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.leftBracket;
    }

    @Override
    public Token getEndToken() {
        if (this.rightBracket != null) {
            return this.rightBracket;
        }
        return this.expression.getEndToken();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Token getLeftBracket() {
        return this.leftBracket;
    }

    public Token getRightBracket() {
        return this.rightBracket;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setLeftBracket(Token token) {
        this.leftBracket = token;
    }

    public void setRightBracket(Token token) {
        this.rightBracket = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.expression, astVisitor);
    }
}

