/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;

public class InstanceCreationExpression
extends Expression {
    private Token keyword;
    private ConstructorName constructorName;
    private ArgumentList argumentList;
    private ConstructorElement staticElement;

    public InstanceCreationExpression(Token token, ConstructorName constructorName, ArgumentList argumentList) {
        this.keyword = token;
        this.constructorName = this.becomeParentOf(constructorName);
        this.argumentList = this.becomeParentOf(argumentList);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitInstanceCreationExpression(this);
    }

    public ArgumentList getArgumentList() {
        return this.argumentList;
    }

    @Override
    public Token getBeginToken() {
        return this.keyword;
    }

    public ConstructorName getConstructorName() {
        return this.constructorName;
    }

    @Override
    public Token getEndToken() {
        return this.argumentList.getEndToken();
    }

    public Token getKeyword() {
        return this.keyword;
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    public ConstructorElement getStaticElement() {
        return this.staticElement;
    }

    public boolean isConst() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.CONST;
    }

    public void setArgumentList(ArgumentList argumentList) {
        this.argumentList = this.becomeParentOf(argumentList);
    }

    public void setConstructorName(ConstructorName constructorName) {
        this.constructorName = constructorName;
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setStaticElement(ConstructorElement constructorElement) {
        this.staticElement = constructorElement;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.constructorName, astVisitor);
        this.safelyVisitChild(this.argumentList, astVisitor);
    }
}

