/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.element.AuxiliaryElements;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.utilities.translation.DartName;

public class IndexExpression
extends Expression {
    private Expression target;
    private Token period;
    private Token leftBracket;
    private Expression index;
    private Token rightBracket;
    private MethodElement staticElement;
    private MethodElement propagatedElement;
    private AuxiliaryElements auxiliaryElements = null;

    @DartName(value="forTarget")
    public IndexExpression(Expression expression, Token token, Expression expression2, Token token2) {
        this.target = this.becomeParentOf(expression);
        this.leftBracket = token;
        this.index = this.becomeParentOf(expression2);
        this.rightBracket = token2;
    }

    @DartName(value="forCascade")
    public IndexExpression(Token token, Token token2, Expression expression, Token token3) {
        this.period = token;
        this.leftBracket = token2;
        this.index = this.becomeParentOf(expression);
        this.rightBracket = token3;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitIndexExpression(this);
    }

    public AuxiliaryElements getAuxiliaryElements() {
        return this.auxiliaryElements;
    }

    @Override
    public Token getBeginToken() {
        if (this.target != null) {
            return this.target.getBeginToken();
        }
        return this.period;
    }

    public MethodElement getBestElement() {
        MethodElement methodElement = this.getPropagatedElement();
        if (methodElement == null) {
            methodElement = this.getStaticElement();
        }
        return methodElement;
    }

    @Override
    public Token getEndToken() {
        return this.rightBracket;
    }

    public Expression getIndex() {
        return this.index;
    }

    public Token getLeftBracket() {
        return this.leftBracket;
    }

    public Token getPeriod() {
        return this.period;
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    public MethodElement getPropagatedElement() {
        return this.propagatedElement;
    }

    public Expression getRealTarget() {
        if (this.isCascaded()) {
            AstNode astNode = this.getParent();
            while (!(astNode instanceof CascadeExpression)) {
                if (astNode == null) {
                    return this.target;
                }
                astNode = astNode.getParent();
            }
            return ((CascadeExpression)astNode).getTarget();
        }
        return this.target;
    }

    public Token getRightBracket() {
        return this.rightBracket;
    }

    public MethodElement getStaticElement() {
        return this.staticElement;
    }

    public Expression getTarget() {
        return this.target;
    }

    public boolean inGetterContext() {
        AssignmentExpression assignmentExpression;
        AstNode astNode = this.getParent();
        return !(astNode instanceof AssignmentExpression) || (assignmentExpression = (AssignmentExpression)astNode).getLeftHandSide() != this || assignmentExpression.getOperator().getType() != TokenType.EQ;
    }

    public boolean inSetterContext() {
        AstNode astNode = this.getParent();
        if (astNode instanceof PrefixExpression) {
            return ((PrefixExpression)astNode).getOperator().getType().isIncrementOperator();
        }
        if (astNode instanceof PostfixExpression) {
            return true;
        }
        if (astNode instanceof AssignmentExpression) {
            return ((AssignmentExpression)astNode).getLeftHandSide() == this;
        }
        return false;
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    public boolean isCascaded() {
        return this.period != null;
    }

    public void setAuxiliaryElements(AuxiliaryElements auxiliaryElements) {
        this.auxiliaryElements = auxiliaryElements;
    }

    public void setIndex(Expression expression) {
        this.index = this.becomeParentOf(expression);
    }

    public void setLeftBracket(Token token) {
        this.leftBracket = token;
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    public void setPropagatedElement(MethodElement methodElement) {
        this.propagatedElement = methodElement;
    }

    public void setRightBracket(Token token) {
        this.rightBracket = token;
    }

    public void setStaticElement(MethodElement methodElement) {
        this.staticElement = methodElement;
    }

    public void setTarget(Expression expression) {
        this.target = this.becomeParentOf(expression);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.target, astVisitor);
        this.safelyVisitChild(this.index, astVisitor);
    }

    protected ParameterElement getPropagatedParameterElementForIndex() {
        if (this.propagatedElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = this.propagatedElement.getParameters();
        if (parameterElementArray.length < 1) {
            return null;
        }
        return parameterElementArray[0];
    }

    protected ParameterElement getStaticParameterElementForIndex() {
        if (this.staticElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = this.staticElement.getParameters();
        if (parameterElementArray.length < 1) {
            return null;
        }
        return parameterElementArray[0];
    }
}

