/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.scanner.Token;

public class IfStatement
extends Statement {
    private Token ifKeyword;
    private Token leftParenthesis;
    private Expression condition;
    private Token rightParenthesis;
    private Statement thenStatement;
    private Token elseKeyword;
    private Statement elseStatement;

    public IfStatement(Token token, Token token2, Expression expression, Token token3, Statement statement, Token token4, Statement statement2) {
        this.ifKeyword = token;
        this.leftParenthesis = token2;
        this.condition = this.becomeParentOf(expression);
        this.rightParenthesis = token3;
        this.thenStatement = this.becomeParentOf(statement);
        this.elseKeyword = token4;
        this.elseStatement = this.becomeParentOf(statement2);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitIfStatement(this);
    }

    @Override
    public Token getBeginToken() {
        return this.ifKeyword;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Token getElseKeyword() {
        return this.elseKeyword;
    }

    public Statement getElseStatement() {
        return this.elseStatement;
    }

    @Override
    public Token getEndToken() {
        if (this.elseStatement != null) {
            return this.elseStatement.getEndToken();
        }
        return this.thenStatement.getEndToken();
    }

    public Token getIfKeyword() {
        return this.ifKeyword;
    }

    public Token getLeftParenthesis() {
        return this.leftParenthesis;
    }

    public Token getRightParenthesis() {
        return this.rightParenthesis;
    }

    public Statement getThenStatement() {
        return this.thenStatement;
    }

    public void setCondition(Expression expression) {
        this.condition = this.becomeParentOf(expression);
    }

    public void setElseKeyword(Token token) {
        this.elseKeyword = token;
    }

    public void setElseStatement(Statement statement) {
        this.elseStatement = this.becomeParentOf(statement);
    }

    public void setIfKeyword(Token token) {
        this.ifKeyword = token;
    }

    public void setLeftParenthesis(Token token) {
        this.leftParenthesis = token;
    }

    public void setRightParenthesis(Token token) {
        this.rightParenthesis = token;
    }

    public void setThenStatement(Statement statement) {
        this.thenStatement = this.becomeParentOf(statement);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.condition, astVisitor);
        this.safelyVisitChild(this.thenStatement, astVisitor);
        this.safelyVisitChild(this.elseStatement, astVisitor);
    }
}

