/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class FunctionTypedFormalParameter
extends NormalFormalParameter {
    private TypeName returnType;
    private FormalParameterList parameters;

    public FunctionTypedFormalParameter(Comment comment, List<Annotation> list, TypeName typeName, SimpleIdentifier simpleIdentifier, FormalParameterList formalParameterList) {
        super(comment, list, simpleIdentifier);
        this.returnType = this.becomeParentOf(typeName);
        this.parameters = this.becomeParentOf(formalParameterList);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitFunctionTypedFormalParameter(this);
    }

    @Override
    public Token getBeginToken() {
        if (this.returnType != null) {
            return this.returnType.getBeginToken();
        }
        return this.getIdentifier().getBeginToken();
    }

    @Override
    public Token getEndToken() {
        return this.parameters.getEndToken();
    }

    public FormalParameterList getParameters() {
        return this.parameters;
    }

    public TypeName getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    public void setParameters(FormalParameterList formalParameterList) {
        this.parameters = this.becomeParentOf(formalParameterList);
    }

    public void setReturnType(TypeName typeName) {
        this.returnType = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.returnType, astVisitor);
        this.safelyVisitChild(this.getIdentifier(), astVisitor);
        this.safelyVisitChild(this.parameters, astVisitor);
    }
}

