/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.scanner.Token;

public class FunctionExpressionInvocation
extends Expression {
    private Expression function;
    private ArgumentList argumentList;
    private ExecutableElement staticElement;
    private ExecutableElement propagatedElement;

    public FunctionExpressionInvocation(Expression expression, ArgumentList argumentList) {
        this.function = this.becomeParentOf(expression);
        this.argumentList = this.becomeParentOf(argumentList);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitFunctionExpressionInvocation(this);
    }

    public ArgumentList getArgumentList() {
        return this.argumentList;
    }

    @Override
    public Token getBeginToken() {
        return this.function.getBeginToken();
    }

    public ExecutableElement getBestElement() {
        ExecutableElement executableElement = this.getPropagatedElement();
        if (executableElement == null) {
            executableElement = this.getStaticElement();
        }
        return executableElement;
    }

    @Override
    public Token getEndToken() {
        return this.argumentList.getEndToken();
    }

    public Expression getFunction() {
        return this.function;
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    public ExecutableElement getPropagatedElement() {
        return this.propagatedElement;
    }

    public ExecutableElement getStaticElement() {
        return this.staticElement;
    }

    public void setArgumentList(ArgumentList argumentList) {
        this.argumentList = this.becomeParentOf(argumentList);
    }

    public void setFunction(Expression expression) {
        expression = this.becomeParentOf(expression);
    }

    public void setPropagatedElement(ExecutableElement executableElement) {
        this.propagatedElement = executableElement;
    }

    public void setStaticElement(ExecutableElement executableElement) {
        this.staticElement = executableElement;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.function, astVisitor);
        this.safelyVisitChild(this.argumentList, astVisitor);
    }
}

