/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.scanner.Token;

public class FunctionExpression
extends Expression {
    private FormalParameterList parameters;
    private FunctionBody body;
    private ExecutableElement element;

    public FunctionExpression(FormalParameterList formalParameterList, FunctionBody functionBody) {
        this.parameters = this.becomeParentOf(formalParameterList);
        this.body = this.becomeParentOf(functionBody);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitFunctionExpression(this);
    }

    @Override
    public Token getBeginToken() {
        if (this.parameters != null) {
            return this.parameters.getBeginToken();
        }
        if (this.body != null) {
            return this.body.getBeginToken();
        }
        throw new IllegalStateException("Non-external functions must have a body");
    }

    public FunctionBody getBody() {
        return this.body;
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    @Override
    public Token getEndToken() {
        if (this.body != null) {
            return this.body.getEndToken();
        }
        if (this.parameters != null) {
            return this.parameters.getEndToken();
        }
        throw new IllegalStateException("Non-external functions must have a body");
    }

    public FormalParameterList getParameters() {
        return this.parameters;
    }

    @Override
    public int getPrecedence() {
        return 16;
    }

    public void setBody(FunctionBody functionBody) {
        this.body = this.becomeParentOf(functionBody);
    }

    public void setElement(ExecutableElement executableElement) {
        this.element = executableElement;
    }

    public void setParameters(FormalParameterList formalParameterList) {
        this.parameters = this.becomeParentOf(formalParameterList);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.parameters, astVisitor);
        this.safelyVisitChild(this.body, astVisitor);
    }
}

