/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CompilationUnitMember;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class FunctionDeclaration
extends CompilationUnitMember {
    private Token externalKeyword;
    private TypeName returnType;
    private Token propertyKeyword;
    private SimpleIdentifier name;
    private FunctionExpression functionExpression;

    public FunctionDeclaration(Comment comment, List<Annotation> list, Token token, TypeName typeName, Token token2, SimpleIdentifier simpleIdentifier, FunctionExpression functionExpression) {
        super(comment, list);
        this.externalKeyword = token;
        this.returnType = this.becomeParentOf(typeName);
        this.propertyKeyword = token2;
        this.name = this.becomeParentOf(simpleIdentifier);
        this.functionExpression = this.becomeParentOf(functionExpression);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitFunctionDeclaration(this);
    }

    @Override
    public ExecutableElement getElement() {
        return this.name != null ? (ExecutableElement)this.name.getStaticElement() : null;
    }

    @Override
    public Token getEndToken() {
        return this.functionExpression.getEndToken();
    }

    public Token getExternalKeyword() {
        return this.externalKeyword;
    }

    public FunctionExpression getFunctionExpression() {
        return this.functionExpression;
    }

    public SimpleIdentifier getName() {
        return this.name;
    }

    public Token getPropertyKeyword() {
        return this.propertyKeyword;
    }

    public TypeName getReturnType() {
        return this.returnType;
    }

    public boolean isGetter() {
        return this.propertyKeyword != null && ((KeywordToken)this.propertyKeyword).getKeyword() == Keyword.GET;
    }

    public boolean isSetter() {
        return this.propertyKeyword != null && ((KeywordToken)this.propertyKeyword).getKeyword() == Keyword.SET;
    }

    public void setExternalKeyword(Token token) {
        this.externalKeyword = token;
    }

    public void setFunctionExpression(FunctionExpression functionExpression) {
        functionExpression = this.becomeParentOf(functionExpression);
    }

    public void setName(SimpleIdentifier simpleIdentifier) {
        this.name = this.becomeParentOf(simpleIdentifier);
    }

    public void setPropertyKeyword(Token token) {
        this.propertyKeyword = token;
    }

    public void setReturnType(TypeName typeName) {
        this.returnType = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.returnType, astVisitor);
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.functionExpression, astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        if (this.externalKeyword != null) {
            return this.externalKeyword;
        }
        if (this.returnType != null) {
            return this.returnType.getBeginToken();
        }
        if (this.propertyKeyword != null) {
            return this.propertyKeyword;
        }
        if (this.name != null) {
            return this.name.getBeginToken();
        }
        return this.functionExpression.getBeginToken();
    }
}

