/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class FormalParameterList
extends AstNode {
    private Token leftParenthesis;
    private NodeList<FormalParameter> parameters = new NodeList(this);
    private Token leftDelimiter;
    private Token rightDelimiter;
    private Token rightParenthesis;

    public FormalParameterList(Token token, List<FormalParameter> list, Token token2, Token token3, Token token4) {
        this.leftParenthesis = token;
        this.parameters.addAll(list);
        this.leftDelimiter = token2;
        this.rightDelimiter = token3;
        this.rightParenthesis = token4;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitFormalParameterList(this);
    }

    @Override
    public Token getBeginToken() {
        return this.leftParenthesis;
    }

    @Override
    public Token getEndToken() {
        return this.rightParenthesis;
    }

    public Token getLeftDelimiter() {
        return this.leftDelimiter;
    }

    public Token getLeftParenthesis() {
        return this.leftParenthesis;
    }

    public ParameterElement[] getParameterElements() {
        int n = this.parameters.size();
        ParameterElement[] parameterElementArray = new ParameterElement[n];
        for (int i = 0; i < n; ++i) {
            parameterElementArray[i] = ((FormalParameter)this.parameters.get(i)).getElement();
        }
        return parameterElementArray;
    }

    public NodeList<FormalParameter> getParameters() {
        return this.parameters;
    }

    public Token getRightDelimiter() {
        return this.rightDelimiter;
    }

    public Token getRightParenthesis() {
        return this.rightParenthesis;
    }

    public void setLeftDelimiter(Token token) {
        this.leftDelimiter = token;
    }

    public void setLeftParenthesis(Token token) {
        this.leftParenthesis = token;
    }

    public void setRightDelimiter(Token token) {
        this.rightDelimiter = token;
    }

    public void setRightParenthesis(Token token) {
        this.rightParenthesis = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.parameters.accept(astVisitor);
    }
}

