/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class ForStatement
extends Statement {
    private Token forKeyword;
    private Token leftParenthesis;
    private VariableDeclarationList variableList;
    private Expression initialization;
    private Token leftSeparator;
    private Expression condition;
    private Token rightSeparator;
    private NodeList<Expression> updaters = new NodeList(this);
    private Token rightParenthesis;
    private Statement body;

    public ForStatement(Token token, Token token2, VariableDeclarationList variableDeclarationList, Expression expression, Token token3, Expression expression2, Token token4, List<Expression> list, Token token5, Statement statement) {
        this.forKeyword = token;
        this.leftParenthesis = token2;
        this.variableList = this.becomeParentOf(variableDeclarationList);
        this.initialization = this.becomeParentOf(expression);
        this.leftSeparator = token3;
        this.condition = this.becomeParentOf(expression2);
        this.rightSeparator = token4;
        this.updaters.addAll(list);
        this.rightParenthesis = token5;
        this.body = this.becomeParentOf(statement);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitForStatement(this);
    }

    @Override
    public Token getBeginToken() {
        return this.forKeyword;
    }

    public Statement getBody() {
        return this.body;
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public Token getEndToken() {
        return this.body.getEndToken();
    }

    public Token getForKeyword() {
        return this.forKeyword;
    }

    public Expression getInitialization() {
        return this.initialization;
    }

    public Token getLeftParenthesis() {
        return this.leftParenthesis;
    }

    public Token getLeftSeparator() {
        return this.leftSeparator;
    }

    public Token getRightParenthesis() {
        return this.rightParenthesis;
    }

    public Token getRightSeparator() {
        return this.rightSeparator;
    }

    public NodeList<Expression> getUpdaters() {
        return this.updaters;
    }

    public VariableDeclarationList getVariables() {
        return this.variableList;
    }

    public void setBody(Statement statement) {
        this.body = this.becomeParentOf(statement);
    }

    public void setCondition(Expression expression) {
        this.condition = this.becomeParentOf(expression);
    }

    public void setForKeyword(Token token) {
        this.forKeyword = token;
    }

    public void setInitialization(Expression expression) {
        this.initialization = this.becomeParentOf(expression);
    }

    public void setLeftParenthesis(Token token) {
        this.leftParenthesis = token;
    }

    public void setLeftSeparator(Token token) {
        this.leftSeparator = token;
    }

    public void setRightParenthesis(Token token) {
        this.rightParenthesis = token;
    }

    public void setRightSeparator(Token token) {
        this.rightSeparator = token;
    }

    public void setVariables(VariableDeclarationList variableDeclarationList) {
        variableDeclarationList = this.becomeParentOf(variableDeclarationList);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.variableList, astVisitor);
        this.safelyVisitChild(this.initialization, astVisitor);
        this.safelyVisitChild(this.condition, astVisitor);
        this.updaters.accept(astVisitor);
        this.safelyVisitChild(this.body, astVisitor);
    }
}

