/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class FieldFormalParameter
extends NormalFormalParameter {
    private Token keyword;
    private TypeName type;
    private Token thisToken;
    private Token period;
    private FormalParameterList parameters;

    public FieldFormalParameter(Comment comment, List<Annotation> list, Token token, TypeName typeName, Token token2, Token token3, SimpleIdentifier simpleIdentifier, FormalParameterList formalParameterList) {
        super(comment, list, simpleIdentifier);
        this.keyword = token;
        this.type = this.becomeParentOf(typeName);
        this.thisToken = token2;
        this.period = token3;
        this.parameters = this.becomeParentOf(formalParameterList);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitFieldFormalParameter(this);
    }

    @Override
    public Token getBeginToken() {
        if (this.keyword != null) {
            return this.keyword;
        }
        if (this.type != null) {
            return this.type.getBeginToken();
        }
        return this.thisToken;
    }

    @Override
    public Token getEndToken() {
        return this.getIdentifier().getEndToken();
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public FormalParameterList getParameters() {
        return this.parameters;
    }

    public Token getPeriod() {
        return this.period;
    }

    public Token getThisToken() {
        return this.thisToken;
    }

    public TypeName getType() {
        return this.type;
    }

    @Override
    public boolean isConst() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.CONST;
    }

    @Override
    public boolean isFinal() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.FINAL;
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setParameters(FormalParameterList formalParameterList) {
        this.parameters = this.becomeParentOf(formalParameterList);
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    public void setThisToken(Token token) {
        this.thisToken = token;
    }

    public void setType(TypeName typeName) {
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.type, astVisitor);
        this.safelyVisitChild(this.getIdentifier(), astVisitor);
        this.safelyVisitChild(this.parameters, astVisitor);
    }
}

