/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.scanner.Token;

public class ExpressionStatement
extends Statement {
    private Expression expression;
    private Token semicolon;

    public ExpressionStatement(Expression expression, Token token) {
        this.expression = this.becomeParentOf(expression);
        this.semicolon = token;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitExpressionStatement(this);
    }

    @Override
    public Token getBeginToken() {
        return this.expression.getBeginToken();
    }

    @Override
    public Token getEndToken() {
        if (this.semicolon != null) {
            return this.semicolon;
        }
        return this.expression.getEndToken();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Token getSemicolon() {
        return this.semicolon;
    }

    @Override
    public boolean isSynthetic() {
        return this.expression.isSynthetic() && this.semicolon.isSynthetic();
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setSemicolon(Token token) {
        this.semicolon = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.expression, astVisitor);
    }
}

