/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.scanner.Token;

public class ExpressionFunctionBody
extends FunctionBody {
    private Token functionDefinition;
    private Expression expression;
    private Token semicolon;

    public ExpressionFunctionBody(Token token, Expression expression, Token token2) {
        this.functionDefinition = token;
        this.expression = this.becomeParentOf(expression);
        this.semicolon = token2;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitExpressionFunctionBody(this);
    }

    @Override
    public Token getBeginToken() {
        return this.functionDefinition;
    }

    @Override
    public Token getEndToken() {
        if (this.semicolon != null) {
            return this.semicolon;
        }
        return this.expression.getEndToken();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Token getFunctionDefinition() {
        return this.functionDefinition;
    }

    public Token getSemicolon() {
        return this.semicolon;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setFunctionDefinition(Token token) {
        this.functionDefinition = token;
    }

    public void setSemicolon(Token token) {
        this.semicolon = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.expression, astVisitor);
    }
}

