/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.internal.type.DynamicTypeImpl;
import com.google.dart.engine.type.Type;

public abstract class Expression
extends AstNode {
    public static final Expression[] EMPTY_ARRAY = new Expression[0];
    private Type staticType;
    private Type propagatedType;

    public ParameterElement getBestParameterElement() {
        ParameterElement parameterElement = this.getPropagatedParameterElement();
        if (parameterElement != null) {
            return parameterElement;
        }
        return this.getStaticParameterElement();
    }

    public Type getBestType() {
        if (this.propagatedType != null) {
            return this.propagatedType;
        }
        if (this.staticType != null) {
            return this.staticType;
        }
        return DynamicTypeImpl.getInstance();
    }

    public abstract int getPrecedence();

    public ParameterElement getPropagatedParameterElement() {
        AstNode astNode = this.getParent();
        if (astNode instanceof ArgumentList) {
            return ((ArgumentList)astNode).getPropagatedParameterElementFor(this);
        }
        if (astNode instanceof IndexExpression) {
            IndexExpression indexExpression = (IndexExpression)astNode;
            if (indexExpression.getIndex() == this) {
                return indexExpression.getPropagatedParameterElementForIndex();
            }
        } else if (astNode instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)astNode;
            if (binaryExpression.getRightOperand() == this) {
                return binaryExpression.getPropagatedParameterElementForRightOperand();
            }
        } else if (astNode instanceof AssignmentExpression) {
            AssignmentExpression assignmentExpression = (AssignmentExpression)astNode;
            if (assignmentExpression.getRightHandSide() == this) {
                return assignmentExpression.getPropagatedParameterElementForRightHandSide();
            }
        } else {
            if (astNode instanceof PrefixExpression) {
                return ((PrefixExpression)astNode).getPropagatedParameterElementForOperand();
            }
            if (astNode instanceof PostfixExpression) {
                return ((PostfixExpression)astNode).getPropagatedParameterElementForOperand();
            }
        }
        return null;
    }

    public Type getPropagatedType() {
        return this.propagatedType;
    }

    public ParameterElement getStaticParameterElement() {
        AstNode astNode = this.getParent();
        if (astNode instanceof ArgumentList) {
            return ((ArgumentList)astNode).getStaticParameterElementFor(this);
        }
        if (astNode instanceof IndexExpression) {
            IndexExpression indexExpression = (IndexExpression)astNode;
            if (indexExpression.getIndex() == this) {
                return indexExpression.getStaticParameterElementForIndex();
            }
        } else if (astNode instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)astNode;
            if (binaryExpression.getRightOperand() == this) {
                return binaryExpression.getStaticParameterElementForRightOperand();
            }
        } else if (astNode instanceof AssignmentExpression) {
            AssignmentExpression assignmentExpression = (AssignmentExpression)astNode;
            if (assignmentExpression.getRightHandSide() == this) {
                return assignmentExpression.getStaticParameterElementForRightHandSide();
            }
        } else {
            if (astNode instanceof PrefixExpression) {
                return ((PrefixExpression)astNode).getStaticParameterElementForOperand();
            }
            if (astNode instanceof PostfixExpression) {
                return ((PostfixExpression)astNode).getStaticParameterElementForOperand();
            }
        }
        return null;
    }

    public Type getStaticType() {
        return this.staticType;
    }

    public boolean isAssignable() {
        return false;
    }

    public void setPropagatedType(Type type) {
        this.propagatedType = type;
    }

    public void setStaticType(Type type) {
        this.staticType = type;
    }
}

