/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.utilities.dart.ParameterKind;

public class DefaultFormalParameter
extends FormalParameter {
    private NormalFormalParameter parameter;
    private ParameterKind kind;
    private Token separator;
    private Expression defaultValue;

    public DefaultFormalParameter(NormalFormalParameter normalFormalParameter, ParameterKind parameterKind, Token token, Expression expression) {
        this.parameter = this.becomeParentOf(normalFormalParameter);
        this.kind = parameterKind;
        this.separator = token;
        this.defaultValue = this.becomeParentOf(expression);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitDefaultFormalParameter(this);
    }

    @Override
    public Token getBeginToken() {
        return this.parameter.getBeginToken();
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Token getEndToken() {
        if (this.defaultValue != null) {
            return this.defaultValue.getEndToken();
        }
        return this.parameter.getEndToken();
    }

    @Override
    public SimpleIdentifier getIdentifier() {
        return this.parameter.getIdentifier();
    }

    @Override
    public ParameterKind getKind() {
        return this.kind;
    }

    public NormalFormalParameter getParameter() {
        return this.parameter;
    }

    public Token getSeparator() {
        return this.separator;
    }

    @Override
    public boolean isConst() {
        return this.parameter != null && this.parameter.isConst();
    }

    @Override
    public boolean isFinal() {
        return this.parameter != null && this.parameter.isFinal();
    }

    public void setDefaultValue(Expression expression) {
        this.defaultValue = this.becomeParentOf(expression);
    }

    public void setKind(ParameterKind parameterKind) {
        this.kind = parameterKind;
    }

    public void setParameter(NormalFormalParameter normalFormalParameter) {
        this.parameter = this.becomeParentOf(normalFormalParameter);
    }

    public void setSeparator(Token token) {
        this.separator = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.parameter, astVisitor);
        this.safelyVisitChild(this.defaultValue, astVisitor);
    }
}

