/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.Declaration;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class DeclaredIdentifier
extends Declaration {
    private Token keyword;
    private TypeName type;
    private SimpleIdentifier identifier;

    public DeclaredIdentifier(Comment comment, List<Annotation> list, Token token, TypeName typeName, SimpleIdentifier simpleIdentifier) {
        super(comment, list);
        this.keyword = token;
        this.type = this.becomeParentOf(typeName);
        this.identifier = this.becomeParentOf(simpleIdentifier);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitDeclaredIdentifier(this);
    }

    @Override
    public LocalVariableElement getElement() {
        SimpleIdentifier simpleIdentifier = this.getIdentifier();
        if (simpleIdentifier == null) {
            return null;
        }
        return (LocalVariableElement)simpleIdentifier.getStaticElement();
    }

    @Override
    public Token getEndToken() {
        return this.identifier.getEndToken();
    }

    public SimpleIdentifier getIdentifier() {
        return this.identifier;
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public TypeName getType() {
        return this.type;
    }

    public boolean isConst() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.CONST;
    }

    public boolean isFinal() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.FINAL;
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setType(TypeName typeName) {
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.type, astVisitor);
        this.safelyVisitChild(this.identifier, astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        if (this.keyword != null) {
            return this.keyword;
        }
        if (this.type != null) {
            return this.type.getBeginToken();
        }
        return this.identifier.getBeginToken();
    }
}

