/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.scanner.Token;

public class ConstructorName
extends AstNode {
    private TypeName type;
    private Token period;
    private SimpleIdentifier name;
    private ConstructorElement staticElement;

    public ConstructorName(TypeName typeName, Token token, SimpleIdentifier simpleIdentifier) {
        this.type = this.becomeParentOf(typeName);
        this.period = token;
        this.name = this.becomeParentOf(simpleIdentifier);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitConstructorName(this);
    }

    @Override
    public Token getBeginToken() {
        return this.type.getBeginToken();
    }

    @Override
    public Token getEndToken() {
        if (this.name != null) {
            return this.name.getEndToken();
        }
        return this.type.getEndToken();
    }

    public SimpleIdentifier getName() {
        return this.name;
    }

    public Token getPeriod() {
        return this.period;
    }

    public ConstructorElement getStaticElement() {
        return this.staticElement;
    }

    public TypeName getType() {
        return this.type;
    }

    public void setName(SimpleIdentifier simpleIdentifier) {
        this.name = this.becomeParentOf(simpleIdentifier);
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    public void setStaticElement(ConstructorElement constructorElement) {
        this.staticElement = constructorElement;
    }

    public void setType(TypeName typeName) {
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.type, astVisitor);
        this.safelyVisitChild(this.name, astVisitor);
    }
}

