/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.ConstructorInitializer;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.scanner.Token;

public class ConstructorFieldInitializer
extends ConstructorInitializer {
    private Token keyword;
    private Token period;
    private SimpleIdentifier fieldName;
    private Token equals;
    private Expression expression;

    public ConstructorFieldInitializer(Token token, Token token2, SimpleIdentifier simpleIdentifier, Token token3, Expression expression) {
        this.keyword = token;
        this.period = token2;
        this.fieldName = this.becomeParentOf(simpleIdentifier);
        this.equals = token3;
        this.expression = this.becomeParentOf(expression);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitConstructorFieldInitializer(this);
    }

    @Override
    public Token getBeginToken() {
        if (this.keyword != null) {
            return this.keyword;
        }
        return this.fieldName.getBeginToken();
    }

    @Override
    public Token getEndToken() {
        return this.expression.getEndToken();
    }

    public Token getEquals() {
        return this.equals;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public SimpleIdentifier getFieldName() {
        return this.fieldName;
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public Token getPeriod() {
        return this.period;
    }

    public void setEquals(Token token) {
        this.equals = token;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setFieldName(SimpleIdentifier simpleIdentifier) {
        this.fieldName = this.becomeParentOf(simpleIdentifier);
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.fieldName, astVisitor);
        this.safelyVisitChild(this.expression, astVisitor);
    }
}

