/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.ConstructorInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class ConstructorDeclaration
extends ClassMember {
    private Token externalKeyword;
    private Token constKeyword;
    private Token factoryKeyword;
    private Identifier returnType;
    private Token period;
    private SimpleIdentifier name;
    private FormalParameterList parameters;
    private Token separator;
    private NodeList<ConstructorInitializer> initializers = new NodeList(this);
    private ConstructorName redirectedConstructor;
    private FunctionBody body;
    private ConstructorElement element;

    public ConstructorDeclaration(Comment comment, List<Annotation> list, Token token, Token token2, Token token3, Identifier identifier, Token token4, SimpleIdentifier simpleIdentifier, FormalParameterList formalParameterList, Token token5, List<ConstructorInitializer> list2, ConstructorName constructorName, FunctionBody functionBody) {
        super(comment, list);
        this.externalKeyword = token;
        this.constKeyword = token2;
        this.factoryKeyword = token3;
        this.returnType = this.becomeParentOf(identifier);
        this.period = token4;
        this.name = this.becomeParentOf(simpleIdentifier);
        this.parameters = this.becomeParentOf(formalParameterList);
        this.separator = token5;
        this.initializers.addAll(list2);
        this.redirectedConstructor = this.becomeParentOf(constructorName);
        this.body = this.becomeParentOf(functionBody);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitConstructorDeclaration(this);
    }

    public FunctionBody getBody() {
        return this.body;
    }

    public Token getConstKeyword() {
        return this.constKeyword;
    }

    @Override
    public ConstructorElement getElement() {
        return this.element;
    }

    @Override
    public Token getEndToken() {
        if (this.body != null) {
            return this.body.getEndToken();
        }
        if (!this.initializers.isEmpty()) {
            return this.initializers.getEndToken();
        }
        return this.parameters.getEndToken();
    }

    public Token getExternalKeyword() {
        return this.externalKeyword;
    }

    public Token getFactoryKeyword() {
        return this.factoryKeyword;
    }

    public NodeList<ConstructorInitializer> getInitializers() {
        return this.initializers;
    }

    public SimpleIdentifier getName() {
        return this.name;
    }

    public FormalParameterList getParameters() {
        return this.parameters;
    }

    public Token getPeriod() {
        return this.period;
    }

    public ConstructorName getRedirectedConstructor() {
        return this.redirectedConstructor;
    }

    public Identifier getReturnType() {
        return this.returnType;
    }

    public Token getSeparator() {
        return this.separator;
    }

    public void setBody(FunctionBody functionBody) {
        this.body = this.becomeParentOf(functionBody);
    }

    public void setConstKeyword(Token token) {
        this.constKeyword = token;
    }

    public void setElement(ConstructorElement constructorElement) {
        this.element = constructorElement;
    }

    public void setExternalKeyword(Token token) {
        this.externalKeyword = token;
    }

    public void setFactoryKeyword(Token token) {
        this.factoryKeyword = token;
    }

    public void setName(SimpleIdentifier simpleIdentifier) {
        this.name = this.becomeParentOf(simpleIdentifier);
    }

    public void setParameters(FormalParameterList formalParameterList) {
        this.parameters = this.becomeParentOf(formalParameterList);
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    public void setRedirectedConstructor(ConstructorName constructorName) {
        this.redirectedConstructor = this.becomeParentOf(constructorName);
    }

    public void setReturnType(Identifier identifier) {
        this.returnType = this.becomeParentOf(identifier);
    }

    public void setSeparator(Token token) {
        this.separator = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.returnType, astVisitor);
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.parameters, astVisitor);
        this.initializers.accept(astVisitor);
        this.safelyVisitChild(this.redirectedConstructor, astVisitor);
        this.safelyVisitChild(this.body, astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        Token token = this.leftMost(this.externalKeyword, this.constKeyword, this.factoryKeyword);
        if (token != null) {
            return token;
        }
        return this.returnType.getBeginToken();
    }

    private Token leftMost(Token ... tokenArray) {
        Token token = null;
        int n = Integer.MAX_VALUE;
        for (Token token2 : tokenArray) {
            if (token2 == null || token2.getOffset() >= n) continue;
            token = token2;
        }
        return token;
    }
}

