/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.scanner.Token;

public class ConditionalExpression
extends Expression {
    private Expression condition;
    private Token question;
    private Expression thenExpression;
    private Token colon;
    private Expression elseExpression;

    public ConditionalExpression(Expression expression, Token token, Expression expression2, Token token2, Expression expression3) {
        this.condition = this.becomeParentOf(expression);
        this.question = token;
        this.thenExpression = this.becomeParentOf(expression2);
        this.colon = token2;
        this.elseExpression = this.becomeParentOf(expression3);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitConditionalExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.condition.getBeginToken();
    }

    public Token getColon() {
        return this.colon;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    @Override
    public Token getEndToken() {
        return this.elseExpression.getEndToken();
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    public Token getQuestion() {
        return this.question;
    }

    public Expression getThenExpression() {
        return this.thenExpression;
    }

    public void setColon(Token token) {
        this.colon = token;
    }

    public void setCondition(Expression expression) {
        this.condition = this.becomeParentOf(expression);
    }

    public void setElseExpression(Expression expression) {
        this.elseExpression = this.becomeParentOf(expression);
    }

    public void setQuestion(Token token) {
        this.question = token;
    }

    public void setThenExpression(Expression expression) {
        this.thenExpression = this.becomeParentOf(expression);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.condition, astVisitor);
        this.safelyVisitChild(this.thenExpression, astVisitor);
        this.safelyVisitChild(this.elseExpression, astVisitor);
    }
}

