/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AnnotatedNode;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.CompilationUnitMember;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.ScriptTag;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.utilities.source.LineInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompilationUnit
extends AstNode {
    private Token beginToken;
    private ScriptTag scriptTag;
    private NodeList<Directive> directives = new NodeList(this);
    private NodeList<CompilationUnitMember> declarations = new NodeList(this);
    private Token endToken;
    private CompilationUnitElement element;
    private LineInfo lineInfo;

    public CompilationUnit(Token token, ScriptTag scriptTag, List<Directive> list, List<CompilationUnitMember> list2, Token token2) {
        this.beginToken = token;
        this.scriptTag = this.becomeParentOf(scriptTag);
        this.directives.addAll(list);
        this.declarations.addAll(list2);
        this.endToken = token2;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitCompilationUnit(this);
    }

    @Override
    public Token getBeginToken() {
        return this.beginToken;
    }

    public NodeList<CompilationUnitMember> getDeclarations() {
        return this.declarations;
    }

    public NodeList<Directive> getDirectives() {
        return this.directives;
    }

    public CompilationUnitElement getElement() {
        return this.element;
    }

    @Override
    public Token getEndToken() {
        return this.endToken;
    }

    @Override
    public int getLength() {
        Token token = this.getEndToken();
        if (token == null) {
            return 0;
        }
        return token.getOffset() + token.getLength();
    }

    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    @Override
    public int getOffset() {
        return 0;
    }

    public ScriptTag getScriptTag() {
        return this.scriptTag;
    }

    public void setElement(CompilationUnitElement compilationUnitElement) {
        this.element = compilationUnitElement;
    }

    public void setLineInfo(LineInfo lineInfo) {
        this.lineInfo = lineInfo;
    }

    public void setScriptTag(ScriptTag scriptTag) {
        this.scriptTag = this.becomeParentOf(scriptTag);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.scriptTag, astVisitor);
        if (this.directivesAreBeforeDeclarations()) {
            this.directives.accept(astVisitor);
            this.declarations.accept(astVisitor);
        } else {
            for (AstNode astNode : this.getSortedDirectivesAndDeclarations()) {
                astNode.accept(astVisitor);
            }
        }
    }

    private boolean directivesAreBeforeDeclarations() {
        if (this.directives.isEmpty() || this.declarations.isEmpty()) {
            return true;
        }
        Directive directive = (Directive)this.directives.get(this.directives.size() - 1);
        CompilationUnitMember compilationUnitMember = (CompilationUnitMember)this.declarations.get(0);
        return directive.getOffset() < compilationUnitMember.getOffset();
    }

    private AstNode[] getSortedDirectivesAndDeclarations() {
        ArrayList<AnnotatedNode> arrayList = new ArrayList<AnnotatedNode>();
        arrayList.addAll(this.directives);
        arrayList.addAll(this.declarations);
        AstNode[] astNodeArray = arrayList.toArray(new AstNode[arrayList.size()]);
        Arrays.sort(astNodeArray, AstNode.LEXICAL_ORDER);
        return astNodeArray;
    }
}

