/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.CommentReference;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.scanner.Token;
import java.util.ArrayList;
import java.util.List;

public class Comment
extends AstNode {
    private Token[] tokens;
    private CommentType type;
    private NodeList<CommentReference> references = new NodeList(this);

    public static Comment createBlockComment(Token[] tokenArray) {
        return new Comment(tokenArray, CommentType.BLOCK, null);
    }

    public static Comment createDocumentationComment(Token[] tokenArray) {
        return new Comment(tokenArray, CommentType.DOCUMENTATION, new ArrayList<CommentReference>());
    }

    public static Comment createDocumentationCommentWithReferences(Token[] tokenArray, List<CommentReference> list) {
        return new Comment(tokenArray, CommentType.DOCUMENTATION, list);
    }

    public static Comment createEndOfLineComment(Token[] tokenArray) {
        return new Comment(tokenArray, CommentType.END_OF_LINE, null);
    }

    private Comment(Token[] tokenArray, CommentType commentType, List<CommentReference> list) {
        this.tokens = tokenArray;
        this.type = commentType;
        this.references.addAll(list);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitComment(this);
    }

    @Override
    public Token getBeginToken() {
        return this.tokens[0];
    }

    @Override
    public Token getEndToken() {
        return this.tokens[this.tokens.length - 1];
    }

    public NodeList<CommentReference> getReferences() {
        return this.references;
    }

    public Token[] getTokens() {
        return this.tokens;
    }

    public boolean isBlock() {
        return this.type == CommentType.BLOCK;
    }

    public boolean isDocumentation() {
        return this.type == CommentType.DOCUMENTATION;
    }

    public boolean isEndOfLine() {
        return this.type == CommentType.END_OF_LINE;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.references.accept(astVisitor);
    }

    private static enum CommentType {
        END_OF_LINE,
        BLOCK,
        DOCUMENTATION;

    }
}

