/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CompilationUnitMember;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ExtendsClause;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.ImplementsClause;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.NativeClause;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeParameterList;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.WithClause;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class ClassDeclaration
extends CompilationUnitMember {
    private Token abstractKeyword;
    private Token classKeyword;
    private SimpleIdentifier name;
    private TypeParameterList typeParameters;
    private ExtendsClause extendsClause;
    private WithClause withClause;
    private ImplementsClause implementsClause;
    private NativeClause nativeClause;
    private Token leftBracket;
    private NodeList<ClassMember> members = new NodeList(this);
    private Token rightBracket;

    public ClassDeclaration(Comment comment, List<Annotation> list, Token token, Token token2, SimpleIdentifier simpleIdentifier, TypeParameterList typeParameterList, ExtendsClause extendsClause, WithClause withClause, ImplementsClause implementsClause, Token token3, List<ClassMember> list2, Token token4) {
        super(comment, list);
        this.abstractKeyword = token;
        this.classKeyword = token2;
        this.name = this.becomeParentOf(simpleIdentifier);
        this.typeParameters = this.becomeParentOf(typeParameterList);
        this.extendsClause = this.becomeParentOf(extendsClause);
        this.withClause = this.becomeParentOf(withClause);
        this.implementsClause = this.becomeParentOf(implementsClause);
        this.leftBracket = token3;
        this.members.addAll(list2);
        this.rightBracket = token4;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitClassDeclaration(this);
    }

    public Token getAbstractKeyword() {
        return this.abstractKeyword;
    }

    public Token getClassKeyword() {
        return this.classKeyword;
    }

    public ConstructorDeclaration getConstructor(String string) {
        for (ClassMember classMember : this.members) {
            if (!(classMember instanceof ConstructorDeclaration)) continue;
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)classMember;
            SimpleIdentifier simpleIdentifier = constructorDeclaration.getName();
            if (string == null && simpleIdentifier == null) {
                return constructorDeclaration;
            }
            if (simpleIdentifier == null || !simpleIdentifier.getName().equals(string)) continue;
            return constructorDeclaration;
        }
        return null;
    }

    @Override
    public ClassElement getElement() {
        return this.name != null ? (ClassElement)this.name.getStaticElement() : null;
    }

    @Override
    public Token getEndToken() {
        return this.rightBracket;
    }

    public ExtendsClause getExtendsClause() {
        return this.extendsClause;
    }

    public VariableDeclaration getField(String string) {
        for (ClassMember classMember : this.members) {
            if (!(classMember instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)classMember;
            NodeList<VariableDeclaration> nodeList = fieldDeclaration.getFields().getVariables();
            for (VariableDeclaration variableDeclaration : nodeList) {
                SimpleIdentifier simpleIdentifier = variableDeclaration.getName();
                if (simpleIdentifier == null || !string.equals(simpleIdentifier.getName())) continue;
                return variableDeclaration;
            }
        }
        return null;
    }

    public ImplementsClause getImplementsClause() {
        return this.implementsClause;
    }

    public Token getLeftBracket() {
        return this.leftBracket;
    }

    public NodeList<ClassMember> getMembers() {
        return this.members;
    }

    public MethodDeclaration getMethod(String string) {
        for (ClassMember classMember : this.members) {
            MethodDeclaration methodDeclaration;
            SimpleIdentifier simpleIdentifier;
            if (!(classMember instanceof MethodDeclaration) || (simpleIdentifier = (methodDeclaration = (MethodDeclaration)classMember).getName()) == null || !string.equals(simpleIdentifier.getName())) continue;
            return methodDeclaration;
        }
        return null;
    }

    public SimpleIdentifier getName() {
        return this.name;
    }

    public NativeClause getNativeClause() {
        return this.nativeClause;
    }

    public Token getRightBracket() {
        return this.rightBracket;
    }

    public TypeParameterList getTypeParameters() {
        return this.typeParameters;
    }

    public WithClause getWithClause() {
        return this.withClause;
    }

    public void setAbstractKeyword(Token token) {
        this.abstractKeyword = token;
    }

    public void setClassKeyword(Token token) {
        this.classKeyword = token;
    }

    public void setExtendsClause(ExtendsClause extendsClause) {
        this.extendsClause = this.becomeParentOf(extendsClause);
    }

    public void setImplementsClause(ImplementsClause implementsClause) {
        this.implementsClause = this.becomeParentOf(implementsClause);
    }

    public void setLeftBracket(Token token) {
        this.leftBracket = token;
    }

    public void setName(SimpleIdentifier simpleIdentifier) {
        this.name = this.becomeParentOf(simpleIdentifier);
    }

    public void setNativeClause(NativeClause nativeClause) {
        this.nativeClause = nativeClause;
    }

    public void setRightBracket(Token token) {
        this.rightBracket = token;
    }

    public void setTypeParameters(TypeParameterList typeParameterList) {
        this.typeParameters = typeParameterList;
    }

    public void setWithClause(WithClause withClause) {
        this.withClause = this.becomeParentOf(withClause);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.typeParameters, astVisitor);
        this.safelyVisitChild(this.extendsClause, astVisitor);
        this.safelyVisitChild(this.withClause, astVisitor);
        this.safelyVisitChild(this.implementsClause, astVisitor);
        this.safelyVisitChild(this.nativeClause, astVisitor);
        this.getMembers().accept(astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        if (this.abstractKeyword != null) {
            return this.abstractKeyword;
        }
        return this.classKeyword;
    }
}

