/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.scanner.Token;

public class CatchClause
extends AstNode {
    private Token onKeyword;
    private TypeName exceptionType;
    private Token catchKeyword;
    private Token leftParenthesis;
    private SimpleIdentifier exceptionParameter;
    private Token comma;
    private SimpleIdentifier stackTraceParameter;
    private Token rightParenthesis;
    private Block body;

    public CatchClause(Token token, TypeName typeName, Token token2, Token token3, SimpleIdentifier simpleIdentifier, Token token4, SimpleIdentifier simpleIdentifier2, Token token5, Block block) {
        this.onKeyword = token;
        this.exceptionType = this.becomeParentOf(typeName);
        this.catchKeyword = token2;
        this.leftParenthesis = token3;
        this.exceptionParameter = this.becomeParentOf(simpleIdentifier);
        this.comma = token4;
        this.stackTraceParameter = this.becomeParentOf(simpleIdentifier2);
        this.rightParenthesis = token5;
        this.body = this.becomeParentOf(block);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitCatchClause(this);
    }

    @Override
    public Token getBeginToken() {
        if (this.onKeyword != null) {
            return this.onKeyword;
        }
        return this.catchKeyword;
    }

    public Block getBody() {
        return this.body;
    }

    public Token getCatchKeyword() {
        return this.catchKeyword;
    }

    public Token getComma() {
        return this.comma;
    }

    @Override
    public Token getEndToken() {
        return this.body.getEndToken();
    }

    public SimpleIdentifier getExceptionParameter() {
        return this.exceptionParameter;
    }

    public TypeName getExceptionType() {
        return this.exceptionType;
    }

    public Token getLeftParenthesis() {
        return this.leftParenthesis;
    }

    public Token getOnKeyword() {
        return this.onKeyword;
    }

    public Token getRightParenthesis() {
        return this.rightParenthesis;
    }

    public SimpleIdentifier getStackTraceParameter() {
        return this.stackTraceParameter;
    }

    public void setBody(Block block) {
        this.body = this.becomeParentOf(block);
    }

    public void setCatchKeyword(Token token) {
        this.catchKeyword = token;
    }

    public void setComma(Token token) {
        this.comma = token;
    }

    public void setExceptionParameter(SimpleIdentifier simpleIdentifier) {
        this.exceptionParameter = this.becomeParentOf(simpleIdentifier);
    }

    public void setExceptionType(TypeName typeName) {
        this.exceptionType = typeName;
    }

    public void setLeftParenthesis(Token token) {
        this.leftParenthesis = token;
    }

    public void setOnKeyword(Token token) {
        this.onKeyword = token;
    }

    public void setRightParenthesis(Token token) {
        this.rightParenthesis = token;
    }

    public void setStackTraceParameter(SimpleIdentifier simpleIdentifier) {
        this.stackTraceParameter = this.becomeParentOf(simpleIdentifier);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.exceptionType, astVisitor);
        this.safelyVisitChild(this.exceptionParameter, astVisitor);
        this.safelyVisitChild(this.stackTraceParameter, astVisitor);
        this.safelyVisitChild(this.body, astVisitor);
    }
}

