/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class CascadeExpression
extends Expression {
    private Expression target;
    private NodeList<Expression> cascadeSections = new NodeList(this);

    public CascadeExpression(Expression expression, List<Expression> list) {
        this.target = this.becomeParentOf(expression);
        this.cascadeSections.addAll(list);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitCascadeExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.target.getBeginToken();
    }

    public NodeList<Expression> getCascadeSections() {
        return this.cascadeSections;
    }

    @Override
    public Token getEndToken() {
        return this.cascadeSections.getEndToken();
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    public Expression getTarget() {
        return this.target;
    }

    public void setTarget(Expression expression) {
        this.target = this.becomeParentOf(expression);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.target, astVisitor);
        this.cascadeSections.accept(astVisitor);
    }
}

