/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.scanner.Token;

public class BinaryExpression
extends Expression {
    private Expression leftOperand;
    private Token operator;
    private Expression rightOperand;
    private MethodElement staticElement;
    private MethodElement propagatedElement;

    public BinaryExpression(Expression expression, Token token, Expression expression2) {
        this.leftOperand = this.becomeParentOf(expression);
        this.operator = token;
        this.rightOperand = this.becomeParentOf(expression2);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitBinaryExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.leftOperand.getBeginToken();
    }

    public MethodElement getBestElement() {
        MethodElement methodElement = this.getPropagatedElement();
        if (methodElement == null) {
            methodElement = this.getStaticElement();
        }
        return methodElement;
    }

    @Override
    public Token getEndToken() {
        return this.rightOperand.getEndToken();
    }

    public Expression getLeftOperand() {
        return this.leftOperand;
    }

    public Token getOperator() {
        return this.operator;
    }

    @Override
    public int getPrecedence() {
        return this.operator.getType().getPrecedence();
    }

    public MethodElement getPropagatedElement() {
        return this.propagatedElement;
    }

    public Expression getRightOperand() {
        return this.rightOperand;
    }

    public MethodElement getStaticElement() {
        return this.staticElement;
    }

    public void setLeftOperand(Expression expression) {
        this.leftOperand = this.becomeParentOf(expression);
    }

    public void setOperator(Token token) {
        this.operator = token;
    }

    public void setPropagatedElement(MethodElement methodElement) {
        this.propagatedElement = methodElement;
    }

    public void setRightOperand(Expression expression) {
        this.rightOperand = this.becomeParentOf(expression);
    }

    public void setStaticElement(MethodElement methodElement) {
        this.staticElement = methodElement;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.leftOperand, astVisitor);
        this.safelyVisitChild(this.rightOperand, astVisitor);
    }

    protected ParameterElement getPropagatedParameterElementForRightOperand() {
        if (this.propagatedElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = this.propagatedElement.getParameters();
        if (parameterElementArray.length < 1) {
            return null;
        }
        return parameterElementArray[0];
    }

    protected ParameterElement getStaticParameterElementForRightOperand() {
        if (this.staticElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = this.staticElement.getParameters();
        if (parameterElementArray.length < 1) {
            return null;
        }
        return parameterElementArray[0];
    }
}

