/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.visitor.ToSourceVisitor;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.utilities.io.PrintStringWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public abstract class AstNode {
    public static final AstNode[] EMPTY_ARRAY = new AstNode[0];
    private AstNode parent;
    private Map<String, Object> propertyMap;
    public static final Comparator<AstNode> LEXICAL_ORDER = new Comparator<AstNode>(){

        @Override
        public int compare(AstNode astNode, AstNode astNode2) {
            return astNode2.getOffset() - astNode.getOffset();
        }
    };

    public abstract <R> R accept(AstVisitor<R> var1);

    public <E extends AstNode> E getAncestor(Class<E> clazz) {
        AstNode astNode;
        for (astNode = this; astNode != null && !clazz.isInstance(astNode); astNode = astNode.getParent()) {
        }
        return (E)astNode;
    }

    public abstract Token getBeginToken();

    public int getEnd() {
        return this.getOffset() + this.getLength();
    }

    public abstract Token getEndToken();

    public int getLength() {
        Token token = this.getBeginToken();
        Token token2 = this.getEndToken();
        if (token == null || token2 == null) {
            return -1;
        }
        return token2.getOffset() + token2.getLength() - token.getOffset();
    }

    public int getOffset() {
        Token token = this.getBeginToken();
        if (token == null) {
            return -1;
        }
        return token.getOffset();
    }

    public AstNode getParent() {
        return this.parent;
    }

    public Object getProperty(String string) {
        if (this.propertyMap == null) {
            return null;
        }
        return this.propertyMap.get(string);
    }

    public final AstNode getRoot() {
        AstNode astNode = this;
        AstNode astNode2 = this.getParent();
        while (astNode2 != null) {
            astNode = astNode2;
            astNode2 = astNode.getParent();
        }
        return astNode;
    }

    public boolean isSynthetic() {
        return false;
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            if (this.propertyMap != null) {
                this.propertyMap.remove(string);
                if (this.propertyMap.isEmpty()) {
                    this.propertyMap = null;
                }
            }
        } else {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap<String, Object>();
            }
            this.propertyMap.put(string, object);
        }
    }

    public String toSource() {
        PrintStringWriter printStringWriter = new PrintStringWriter();
        this.accept(new ToSourceVisitor(printStringWriter));
        return printStringWriter.toString();
    }

    public String toString() {
        return this.toSource();
    }

    public abstract void visitChildren(AstVisitor<?> var1);

    protected <T extends AstNode> T becomeParentOf(T t) {
        if (t != null) {
            T t2 = t;
            super.setParent(this);
        }
        return t;
    }

    protected void safelyVisitChild(AstNode astNode, AstVisitor<?> astVisitor) {
        if (astNode != null) {
            astNode.accept(astVisitor);
        }
    }

    private void setParent(AstNode astNode) {
        this.parent = astNode;
    }
}

