/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.scanner.Token;

public class AssignmentExpression
extends Expression {
    private Expression leftHandSide;
    private Token operator;
    private Expression rightHandSide;
    private MethodElement staticElement;
    private MethodElement propagatedElement;

    public AssignmentExpression(Expression expression, Token token, Expression expression2) {
        this.leftHandSide = this.becomeParentOf(expression);
        this.operator = token;
        this.rightHandSide = this.becomeParentOf(expression2);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitAssignmentExpression(this);
    }

    @Override
    public Token getBeginToken() {
        return this.leftHandSide.getBeginToken();
    }

    public MethodElement getBestElement() {
        MethodElement methodElement = this.getPropagatedElement();
        if (methodElement == null) {
            methodElement = this.getStaticElement();
        }
        return methodElement;
    }

    @Override
    public Token getEndToken() {
        return this.rightHandSide.getEndToken();
    }

    public Expression getLeftHandSide() {
        return this.leftHandSide;
    }

    public Token getOperator() {
        return this.operator;
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    public MethodElement getPropagatedElement() {
        return this.propagatedElement;
    }

    public Expression getRightHandSide() {
        return this.rightHandSide;
    }

    public MethodElement getStaticElement() {
        return this.staticElement;
    }

    public void setLeftHandSide(Expression expression) {
        this.leftHandSide = this.becomeParentOf(expression);
    }

    public void setOperator(Token token) {
        this.operator = token;
    }

    public void setPropagatedElement(MethodElement methodElement) {
        this.propagatedElement = methodElement;
    }

    public void setRightHandSide(Expression expression) {
        this.rightHandSide = this.becomeParentOf(expression);
    }

    public void setStaticElement(MethodElement methodElement) {
        this.staticElement = methodElement;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.leftHandSide, astVisitor);
        this.safelyVisitChild(this.rightHandSide, astVisitor);
    }

    protected ParameterElement getPropagatedParameterElementForRightHandSide() {
        if (this.propagatedElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = this.propagatedElement.getParameters();
        if (parameterElementArray.length < 1) {
            return null;
        }
        return parameterElementArray[0];
    }

    protected ParameterElement getStaticParameterElementForRightHandSide() {
        if (this.staticElement == null) {
            return null;
        }
        ParameterElement[] parameterElementArray = this.staticElement.getParameters();
        if (parameterElementArray.length < 1) {
            return null;
        }
        return parameterElementArray[0];
    }
}

