/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.scanner.Token;

public class AsExpression
extends Expression {
    private Expression expression;
    private Token asOperator;
    private TypeName type;

    public AsExpression(Expression expression, Token token, TypeName typeName) {
        this.expression = this.becomeParentOf(expression);
        this.asOperator = token;
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitAsExpression(this);
    }

    public Token getAsOperator() {
        return this.asOperator;
    }

    @Override
    public Token getBeginToken() {
        return this.expression.getBeginToken();
    }

    @Override
    public Token getEndToken() {
        return this.type.getEndToken();
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public int getPrecedence() {
        return 7;
    }

    public TypeName getType() {
        return this.type;
    }

    public void setAsOperator(Token token) {
        this.asOperator = token;
    }

    public void setExpression(Expression expression) {
        this.expression = this.becomeParentOf(expression);
    }

    public void setType(TypeName typeName) {
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.expression, astVisitor);
        this.safelyVisitChild(this.type, astVisitor);
    }
}

